<%*
const file = app.workspace.getActiveFile();
if (!file) {
  new Notice("⚠️ Keine aktive Notiz");
  return;
}

// gewünschte Default-Properties
const props = {
  "qualität": 0,
  "wichtigkeit": 0,
  "bearbeitet": false
};

// Dateiinhalt lesen
let content = await app.vault.read(file);

// Fall 1: Noch kein Frontmatter vorhanden
if (!content.trimStart().startsWith("---")) {
  const frontmatter = Object.entries(props)
    .map(([k, v]) => `${k}: ${v}`).join("\n");
  const newContent = `---\n${frontmatter}\n---\n${content}`;
  await app.vault.modify(file, newContent);
  new Notice("✅ Frontmatter hinzugefügt.");
  return;
}

// Fall 2: Frontmatter existiert → fehlende Keys ergänzen
const parts = content.split("---");
const yaml = parts[1].trim().split("\n");
const keys = yaml.map(line => line.split(":")[0].trim());

let updated = false;
for (const [key, value] of Object.entries(props)) {
  if (!keys.includes(key)) {
    yaml.push(`${key}: ${value}`);
    updated = true;
  }
}

if (updated) {
  const newContent = `---\n${yaml.join("\n")}\n---${parts.slice(2).join("---")}`;
  await app.vault.modify(file, newContent);
  new Notice("✅ Fehlende Eigenschaften hinzugefügt.");
} else {
  new Notice("✅ Alle Eigenschaften waren schon vorhanden.");
}
%>